/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.LegendaryDividerMaker;

import LegendaryCardMaker.Icon;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendaryDividerMaker.HeroDividerMaker;
import LegendaryCardMaker.LegendaryDividerMaker.HeroDividerMakerToolbar;
import LegendaryCardMaker.LegendaryHeroMaker.CardRarity;
import LegendaryCardMaker.LegendaryHeroMaker.Hero;
import LegendaryCardMaker.LegendaryHeroMaker.HeroCard;
import LegendaryCardMaker.LegendaryHeroMaker.HeroMaker;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class HeroDividerMakerFrame
extends JDialog {
    HeroDividerMaker hm;
    JLabel label;
    JLabel backLabel;
    JLayeredPane layers;
    JScrollPane scroll;
    HeroDividerMakerToolbar hmt;
    boolean templateMode = false;

    public HeroDividerMakerFrame(Hero hc, boolean horizontal) {
        if (hc == null) {
            hc = new Hero();
            hc.name = "Hero Name";
            HeroCard hcc = HeroMaker.getBlankHeroCard();
            hcc.rarity = CardRarity.COMMON;
            hcc.cardTeam = Icon.valueOf("AVENGERS");
            hcc.cardPower = Icon.valueOf("INSTINCT");
            hc.cards.add(hcc);
            hcc = HeroMaker.getBlankHeroCard();
            hcc.rarity = CardRarity.COMMON;
            hcc.cardTeam = Icon.valueOf("AVENGERS");
            hcc.cardPower = Icon.valueOf("TECH");
            hc.cards.add(hcc);
            hcc = HeroMaker.getBlankHeroCard();
            hcc.rarity = CardRarity.UNCOMMON;
            hcc.cardTeam = Icon.valueOf("AVENGERS");
            hcc.cardPower = Icon.valueOf("STRENGTH");
            hc.cards.add(hcc);
            hcc = HeroMaker.getBlankHeroCard();
            hcc.rarity = CardRarity.RARE;
            hcc.cardTeam = Icon.valueOf("AVENGERS");
            hcc.cardPower = Icon.valueOf("COVERT");
            hc.cards.add(hcc);
            this.templateMode = true;
        } else {
            this.templateMode = false;
        }
        this.hm = new HeroDividerMaker(hc, horizontal);
        this.setTitle("Divider Editor: " + hc.name);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.backLabel = new JLabel();
        this.backLabel.setOpaque(true);
        BufferedImage bi = this.hm.generateDivider();
        ImageIcon icon = new ImageIcon(this.resizeImage(new ImageIcon(bi), 0.5));
        this.label = new JLabel(icon);
        this.label.setOpaque(false);
        this.label.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.backLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.layers = new JLayeredPane();
        this.layers.setLayout(null);
        this.layers.add(this.label, JLayeredPane.PALETTE_LAYER, -1);
        this.layers.add(this.backLabel, JLayeredPane.DEFAULT_LAYER, -1);
        this.layers.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.layers.setPreferredSize(new Dimension(icon.getIconWidth(), icon.getIconHeight()));
        if (this.templateMode) {
            this.layers.addMouseListener(new MouseListener(){
                int startX = 0;
                int startY = 0;

                @Override
                public void mouseReleased(MouseEvent e) {
                    LegendaryCardMakerFrame.lcmf.lcm.dbImageOffsetX += e.getX() - this.startX;
                    LegendaryCardMakerFrame.lcmf.lcm.dbImageOffsetY += e.getY() - this.startY;
                    System.out.println("Released: " + LegendaryCardMakerFrame.lcmf.lcm.dbImageOffsetX + ":" + LegendaryCardMakerFrame.lcmf.lcm.dbImageOffsetY);
                    HeroDividerMakerFrame.this.reRenderCard();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.startX = e.getX();
                    this.startY = e.getY();
                    System.out.println("Pressed: " + this.startX + ":" + this.startY);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        } else {
            this.layers.addMouseListener(new MouseListener(){
                int startX = 0;
                int startY = 0;

                @Override
                public void mouseReleased(MouseEvent e) {
                    HeroDividerMakerFrame.this.hm.hero.imageOffsetX += e.getX() - this.startX;
                    HeroDividerMakerFrame.this.hm.hero.imageOffsetY += e.getY() - this.startY;
                    System.out.println("Released: " + HeroDividerMakerFrame.this.hm.hero.imageOffsetX + ":" + HeroDividerMakerFrame.this.hm.hero.imageOffsetY);
                    HeroDividerMakerFrame.this.reRenderCard();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.startX = e.getX();
                    this.startY = e.getY();
                    System.out.println("Pressed: " + this.startX + ":" + this.startY);
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
        this.scroll = new JScrollPane();
        this.scroll.setViewportView(this.layers);
        this.add(this.scroll);
        int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
        this.setSize((int)((double)this.hm.width / 1.8), (int)((double)this.hm.height / 1.8));
        this.hmt = new HeroDividerMakerToolbar(this.hm, this);
        this.setJMenuBar(this.hmt);
        this.setVisible(true);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public void reRenderCard() {
        BufferedImage bi = this.hm.generateDivider();
        ImageIcon icon = new ImageIcon(this.resizeImage(new ImageIcon(bi), 0.5));
        this.label.setIcon(icon);
        this.label.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.backLabel.setBounds(0, 0, icon.getIconWidth(), icon.getIconHeight());
        this.scroll.setViewportView(this.layers);
        this.validate();
    }
}

